# passenger_wsgi.py
import os
import sys

# Put this directory (where passenger_wsgi.py and app.py live) on the Python path
BASE_DIR = os.path.dirname(__file__)
if BASE_DIR not in sys.path:
    sys.path.insert(0, BASE_DIR)

# Tell the app where ffmpeg lives (so photo.py can find it)
os.environ['FFMPEG_DIR'] = '/home/leadsnip/public_html/tiktok.leadsniper.online/bin'

# (Optional) Activate a virtualenv if you use one on cPanel.
venv_activate = os.path.join(BASE_DIR, 'venv', 'bin', 'activate_this.py')
if os.path.exists(venv_activate):
    with open(venv_activate) as f:
        exec(f.read(), {'__file__': venv_activate})

# Import the Flask app object and expose it as the WSGI entrypoint Passenger expects.
from app import app as application
