-- MobileMart phones table schema
CREATE DATABASE IF NOT EXISTS leadsnip_mobilemart
  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE leadsnip_mobilemart;

CREATE TABLE IF NOT EXISTS phones (
  id               BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  source_url       VARCHAR(1024)   NOT NULL,
  remote_image_url VARCHAR(1024)   DEFAULT NULL,
  local_image_path VARCHAR(1024)   DEFAULT NULL,
  price_text       VARCHAR(255)    DEFAULT NULL,
  price_rs         INT             DEFAULT NULL,
  intro            MEDIUMTEXT      DEFAULT NULL,
  specs_json       LONGTEXT        DEFAULT NULL,
  mapping_json     LONGTEXT        DEFAULT NULL,
  specs_table_md   LONGTEXT        DEFAULT NULL,
  created_at       TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_source_url (source_url(255)),
  KEY idx_price (price_rs),
  KEY idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
