<?php
// config.php — production-ready with on-demand debug (?debug=1)

declare(strict_types=1);

// Debug only if you add ?debug=1 to the URL
define('APP_DEBUG', isset($_GET['debug']) && $_GET['debug'] === '1');
define('APP_TZ', 'Asia/Karachi');
date_default_timezone_set(APP_TZ);

// === Your DB credentials ===
const DB_NAME = 'leadsnip_mobilemart';
const DB_USER = 'leadsnip_yt_user';
const DB_PASS = 'zaibZAIB786';
const DB_HOST = 'localhost';    // host usually 'localhost' on cPanel
const DB_PORT = 3306;           // change only if your host uses a custom port

function db(): PDO {
  static $pdo = null;
  if ($pdo instanceof PDO) return $pdo;

  $hostsToTry = [DB_HOST, '127.0.0.1']; // try both
  $last = null;

  foreach ($hostsToTry as $host) {
    try {
      $dsn = 'mysql:host='.$host.';port='.DB_PORT.';dbname='.DB_NAME.';charset=utf8mb4';
      $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
      ]);
      $pdo->exec('SET NAMES utf8mb4');
      return $pdo;
    } catch (Throwable $e) {
      $last = $e; // remember error and try next host
    }
  }

  // Graceful page for visitors; real error to server log
  http_response_code(503);
  error_log('[MobileMart] DB connect failed: '.($last ? $last->getMessage() : 'unknown'));

  if (APP_DEBUG && $last) {
    // You see this only with ?debug=1
    echo '<pre style="white-space:pre-wrap;font:14px/1.5 monospace">';
    echo 'DB ERROR: ', htmlspecialchars($last->getMessage(), ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8');
    echo "</pre>";
  } else {
    echo '<!doctype html><meta charset="utf-8"><title>Service temporarily unavailable</title>
    <style>body{font:15px/1.5 system-ui;margin:40px;color:#111}.box{max-width:680px}.muted{color:#6b7280}</style>
    <div class="box"><h1>We’ll be right back</h1>
    <p class="muted">Database connection is temporarily unavailable. Please try again shortly.</p></div>';
  }
  exit;
}

// ===== Helpers (unchanged) =====
function h(?string $s): string {
  return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}
function derive_title(array $row): string {
  $title = ''; $kv = [];
  if (!empty($row['mapping_json'])) {
    $kv = json_decode($row['mapping_json'], true); if (!is_array($kv)) $kv = [];
  }
  $brand = $kv['brand'] ?? ($kv['make'] ?? '');
  $model = $kv['model'] ?? ($kv['device'] ?? ($kv['variant'] ?? ''));
  $name  = $kv['name']  ?? ($kv['title'] ?? '');
  if ($brand || $model) $title = trim($brand.' '.$model);
  if (!$title && $name) $title = $name;
  if (!$title) {
    $slug = '';
    if (!empty($row['source_url'])) {
      $parts = parse_url($row['source_url']); $path = rtrim($parts['path'] ?? '', '/');
      $slug  = $path ? basename($path) : '';
    }
    $slug = preg_replace('~[-_]+~', ' ', $slug);
    $title = $slug ? ucwords($slug) : 'Phone';
  }
  return $title;
}
function money(array $row): string {
  if (!empty($row['price_text'])) return $row['price_text'];
  if (!empty($row['price_rs']))  return 'Rs. '.number_format((int)$row['price_rs']);
  return '—';
}
function top_specs(array $row): array {
  $out = []; $kv = [];
  if (!empty($row['mapping_json'])) {
    $kv = json_decode($row['mapping_json'], true); if (!is_array($kv)) $kv = [];
  }
  foreach (['ram'=>'RAM','storage'=>'Storage','battery'=>'Battery','display'=>'Display','camera'=>'Camera','chipset'=>'Chipset','os'=>'OS'] as $k=>$label) {
    if (!empty($kv[$k])) $out[] = $label.': '.$kv[$k];
    if (count($out) >= 4) break;
  }
  return $out;
}
function product_image_url(array $row): string {
  $remote = trim((string)($row['remote_image_url'] ?? ''));
  if ($remote && preg_match('~^https?://~i', $remote)) return $remote;
  $local  = trim((string)($row['local_image_path'] ?? ''));
  if ($local && !preg_match('~^[A-Za-z]:\\\\~', $local)) {
    $local = str_replace('\\', '/', $local);
    return $local;
  }
  return '';
}
function paginate_render(int $page, int $pages, array $qs = []): string {
  if ($pages <= 1) return '';
  $html = '<nav class="pager">';
  $mk = function($p, $label, $disabled=false) use($qs) {
    $qs['page'] = $p; $url = '?'.http_build_query($qs);
    return '<a class="pg '.($disabled?'disabled':'').'" href="'.h($url).'">'.h($label).'</a>';
  };
  $html .= $mk(max(1,$page-1), '« Prev', $page<=1);
  $window = 2; $start = max(1,$page-$window); $end = min($pages,$page+$window);
  for ($i=$start; $i<=$end; $i++) {
    $qs['page'] = $i; $url = '?'.http_build_query($qs);
    $html .= '<a class="pg '.($i===$page?'active':'').'" href="'.h($url).'">'.h((string)$i).'</a>';
  }
  $html .= $mk(min($pages,$page+1), 'Next »', $page>=$pages);
  return $html.'</nav>';
}
